const colorBoxes = document.querySelectorAll(".color-box");
const generateBtn = document.getElementById("generate");

function getRandomColor() {
  const red = Math.floor(Math.random() * 256);
  const green = Math.floor(Math.random() * 256);
  const blue = Math.floor(Math.random() * 256);
  const toHex = (value) => value.toString(16).padStart(2, "0");

  const hex = "#" + toHex(red) + toHex(green) + toHex(blue);
  return hex.toUpperCase();
}

function generatePalette() {
  colorBoxes.forEach((box) => {
    const newColor = getRandomColor();
    box.style.backgroundColor = newColor;
    box.textContent = newColor;
  });
}

async function copyColor(text) {
  try {
    await navigator.clipboard.writeText(text);
    alert(`تم نسخ اللون: ${text}`);
  } catch (error) {
    console.error("Failed to copy: ", error);
    alert("حدث خطأ أثناء النسخ 😢");
  }
}

colorBoxes.forEach((box) => {
  box.addEventListener("click", () => {
    const colorCode = box.textContent.trim();
    copyColor(colorCode);
  });
});

generateBtn.addEventListener("click", () => {
  generatePalette();
});

generatePalette();